/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.faraday.view;

import edu.colorado.phet.faraday.FaradayConstants;
import java.awt.Color;

public abstract class NeedleColorStrategy {
    protected static final Color NORTH_COLOR = FaradayConstants.NORTH_COLOR;
    protected static final Color SOUTH_COLOR = FaradayConstants.SOUTH_COLOR;

    public abstract Color getNorthColor(double var1);

    public abstract Color getSouthColor(double var1);

    public static NeedleColorStrategy createStrategy(Color color) {
        NeedleColorStrategy needleColorStrategy = null;
        needleColorStrategy = color.equals(Color.BLACK) ? new SaturationColorStrategy() : new AlphaColorStrategy();
        return needleColorStrategy;
    }

    public static class AlphaColorStrategy
    extends NeedleColorStrategy {
        public Color getNorthColor(double d) {
            if (d < 0.0 || d > 1.0) {
                throw new IllegalArgumentException("scale must be between 0 and 1: " + d);
            }
            int n = NORTH_COLOR.getRed();
            int n2 = NORTH_COLOR.getGreen();
            int n3 = NORTH_COLOR.getBlue();
            int n4 = AlphaColorStrategy.scaleToAlpha(d);
            return new Color(n, n2, n3, n4);
        }

        public Color getSouthColor(double d) {
            if (d < 0.0 || d > 1.0) {
                throw new IllegalArgumentException("scale must be between 0 and 1: " + d);
            }
            int n = SOUTH_COLOR.getRed();
            int n2 = SOUTH_COLOR.getGreen();
            int n3 = SOUTH_COLOR.getBlue();
            int n4 = AlphaColorStrategy.scaleToAlpha(d);
            return new Color(n, n2, n3, n4);
        }

        private static int scaleToAlpha(double d) {
            return (int)(255.0 * d);
        }
    }

    public static class SaturationColorStrategy
    extends NeedleColorStrategy {
        public Color getNorthColor(double d) {
            if (d < 0.0 || d > 1.0) {
                throw new IllegalArgumentException("scale must be between 0 and 1: " + d);
            }
            int n = SaturationColorStrategy.scaleComponent(d, NORTH_COLOR.getRed());
            int n2 = SaturationColorStrategy.scaleComponent(d, NORTH_COLOR.getGreen());
            int n3 = SaturationColorStrategy.scaleComponent(d, NORTH_COLOR.getBlue());
            return new Color(n, n2, n3);
        }

        public Color getSouthColor(double d) {
            if (d < 0.0 || d > 1.0) {
                throw new IllegalArgumentException("scale must be between 0 and 1: " + d);
            }
            int n = SaturationColorStrategy.scaleComponent(d, SOUTH_COLOR.getRed());
            int n2 = SaturationColorStrategy.scaleComponent(d, SOUTH_COLOR.getGreen());
            int n3 = SaturationColorStrategy.scaleComponent(d, SOUTH_COLOR.getBlue());
            return new Color(n, n2, n3);
        }

        private static int scaleComponent(double d, double d2) {
            return (int)(d * d2);
        }
    }
}

