/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.faraday.view;

import edu.colorado.phet.common.phetcommon.util.SimpleObserver;
import edu.colorado.phet.common.phetgraphics.view.phetgraphics.CompositePhetGraphic;
import edu.colorado.phet.common.phetgraphics.view.phetgraphics.PhetImageGraphic;
import edu.colorado.phet.faraday.FaradayResources;
import edu.colorado.phet.faraday.model.Lightbulb;
import edu.colorado.phet.faraday.util.VariableAlphaImageGraphic;
import edu.colorado.phet.faraday.view.LightRaysGraphic;
import java.awt.Component;
import java.awt.image.BufferedImage;

public class LightbulbGraphic
extends CompositePhetGraphic
implements SimpleObserver {
    private Lightbulb _lightbulbModel;
    private double _previousIntensity;
    private VariableAlphaImageGraphic _glassGraphic;
    private LightRaysGraphic _raysGraphic;
    private double _glassGlowScale;

    public LightbulbGraphic(Component component, Lightbulb lightbulb) {
        super(component);
        assert (component != null);
        assert (lightbulb != null);
        this._lightbulbModel = lightbulb;
        this._lightbulbModel.addObserver(this);
        BufferedImage bufferedImage = FaradayResources.getImage("lightbulb-glass.png");
        this._glassGraphic = new VariableAlphaImageGraphic(component, bufferedImage);
        this.addGraphic(this._glassGraphic, 1.0);
        BufferedImage bufferedImage2 = FaradayResources.getImage("lightbulb-cap.png");
        PhetImageGraphic phetImageGraphic = new PhetImageGraphic(component, bufferedImage2);
        this.addGraphic(phetImageGraphic, 1.0);
        BufferedImage bufferedImage3 = FaradayResources.getImage("lightbulb-base.png");
        PhetImageGraphic phetImageGraphic2 = new PhetImageGraphic(component, bufferedImage3);
        this.addGraphic(phetImageGraphic2, 1.0);
        int n = phetImageGraphic2.getImage().getWidth() / 2;
        int n2 = phetImageGraphic2.getImage().getHeight();
        phetImageGraphic2.setRegistrationPoint(n, n2);
        n = phetImageGraphic.getImage().getWidth() / 2;
        n2 = phetImageGraphic.getImage().getHeight();
        phetImageGraphic.setRegistrationPoint(n, n2);
        phetImageGraphic.setLocation(0, -(phetImageGraphic2.getImage().getHeight() - 10));
        n = this._glassGraphic.getImage().getWidth() / 2;
        n2 = this._glassGraphic.getImage().getHeight();
        this._glassGraphic.setRegistrationPoint(n, n2);
        this._glassGraphic.setLocation(0, -(phetImageGraphic2.getImage().getHeight() + phetImageGraphic.getImage().getHeight() - 10));
        this._raysGraphic = new LightRaysGraphic(component, 30.0);
        this.addGraphic(this._raysGraphic, 2.0);
        this._raysGraphic.setRegistrationPoint(0, 90);
        this._glassGlowScale = 15.0;
        this.update();
    }

    public void setGlassGlowScale(double d) {
        if (d < 0.0) {
            throw new IllegalArgumentException("scale must be >= 0: " + d);
        }
        if (d != this._glassGlowScale) {
            this._glassGlowScale = d;
            this.forceUpdate();
        }
    }

    public double getGlassGlowScale() {
        return this._glassGlowScale;
    }

    private void forceUpdate() {
        this._previousIntensity = -1.0;
        this.update();
    }

    public void update() {
        double d;
        this.setVisible(this._lightbulbModel.isEnabled());
        if (this.isVisible() && (d = this._lightbulbModel.getIntensity()) != this._previousIntensity) {
            this._raysGraphic.setIntensity(d);
            float f = (float)((double)0.35f + this._glassGlowScale * (double)0.65f * (double)((float)d));
            if (f > 1.0f) {
                f = 1.0f;
            }
            this._glassGraphic.setAlpha(f);
            this._previousIntensity = d;
            this.setBoundsDirty();
            this.repaint();
        }
    }
}

