/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.faraday.view;

import edu.colorado.phet.faraday.view.NeedleColorStrategy;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;

class CompassNeedleCache {
    private static Dimension DEFAULT_NEEDLE_SIZE = new Dimension(20, 20);
    private static NeedleColorStrategy DEFAULT_NEEDLE_COLOR_STRATEGY = new NeedleColorStrategy.AlphaColorStrategy();
    private static int NUMBER_OF_SHAPES = 360;
    private static int NUMBER_OF_COLORS = 256;
    private Dimension _needleSize;
    private NeedleColorStrategy _needleColorStrategy;
    private Shape[] _shapeTable;
    private Color[] _northColorTable;
    private Color[] _southColorTable;
    private int _shapeCount;
    private int _northColorCount;
    private int _southColorCount;
    private GeneralPath _somePath;
    private AffineTransform _someTransform;

    public CompassNeedleCache() {
        this(DEFAULT_NEEDLE_SIZE);
    }

    public CompassNeedleCache(Dimension dimension) {
        this(dimension, DEFAULT_NEEDLE_COLOR_STRATEGY);
    }

    public CompassNeedleCache(Dimension dimension, NeedleColorStrategy needleColorStrategy) {
        this._needleSize = new Dimension(dimension.width, dimension.height);
        this._needleColorStrategy = needleColorStrategy;
        this._shapeTable = new Shape[NUMBER_OF_SHAPES];
        this._northColorTable = new Color[NUMBER_OF_COLORS];
        this._southColorTable = new Color[NUMBER_OF_COLORS];
        this._southColorCount = 0;
        this._northColorCount = 0;
        this._shapeCount = 0;
        this._somePath = new GeneralPath();
        this._someTransform = new AffineTransform();
    }

    public void setNeedleSize(Dimension dimension) {
        if (this._needleSize.width != dimension.width && this._needleSize.height != dimension.height) {
            this._needleSize.setSize(dimension.width, dimension.height);
            this.clearShapes();
        }
    }

    public Dimension getNeedleSize() {
        return new Dimension(this._needleSize);
    }

    public void setNeedleColorStrategy(NeedleColorStrategy needleColorStrategy) {
        this._needleColorStrategy = needleColorStrategy;
        this.clearColors();
    }

    public void populate() {
        for (int i = 0; i < NUMBER_OF_SHAPES; ++i) {
            double d = Math.toRadians(i);
            this.getNorthShape(d);
        }
        double d = 1.0 / (double)NUMBER_OF_COLORS;
        for (int i = 0; i < NUMBER_OF_COLORS; ++i) {
            double d2 = (double)i * d;
            this.getNorthColor(d2);
            this.getSouthColor(d2);
        }
    }

    private void clearShapes() {
        for (int i = 0; i < this._shapeTable.length; ++i) {
            this._shapeTable[i] = null;
        }
        this._shapeCount = 0;
    }

    private void clearColors() {
        for (int i = 0; i < this._northColorTable.length; ++i) {
            this._northColorTable[i] = null;
            this._southColorTable[i] = null;
        }
        this._southColorCount = 0;
        this._northColorCount = 0;
    }

    public Shape getNorthShape(double d) {
        Shape shape;
        int n = (int)Math.abs(Math.toDegrees(d)) % 360;
        if (d < 0.0) {
            n = (-n + 360) % 360;
        }
        if ((shape = this._shapeTable[n]) == null) {
            this._somePath.reset();
            this._somePath.moveTo(0.0f, -(this._needleSize.height / 2));
            this._somePath.lineTo(this._needleSize.width / 2, 0.0f);
            this._somePath.lineTo(0.0f, this._needleSize.height / 2);
            this._somePath.closePath();
            this._someTransform.setToIdentity();
            this._someTransform.rotate(Math.toRadians(n));
            this._shapeTable[n] = shape = this._someTransform.createTransformedShape(this._somePath);
            ++this._shapeCount;
            assert (this._shapeCount <= NUMBER_OF_SHAPES);
        }
        return shape;
    }

    public Shape getSouthShape(double d) {
        return this.getNorthShape(d + Math.PI);
    }

    public Color getNorthColor(double d) {
        assert (d >= 0.0 && d <= 1.0);
        int n = (int)(255.0 * d);
        Color color = this._northColorTable[n];
        if (color == null) {
            this._northColorTable[n] = color = this._needleColorStrategy.getNorthColor(d);
            ++this._northColorCount;
            assert (this._northColorCount <= NUMBER_OF_COLORS);
        }
        return color;
    }

    public Color getSouthColor(double d) {
        assert (d >= 0.0 && d <= 1.0);
        int n = (int)(255.0 * d);
        Color color = this._southColorTable[n];
        if (color == null) {
            this._southColorTable[n] = color = this._needleColorStrategy.getSouthColor(d);
            ++this._southColorCount;
            assert (this._southColorCount <= NUMBER_OF_COLORS);
        }
        return color;
    }
}

