/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.faraday.control.menu;

import edu.colorado.phet.common.phetcommon.application.PhetApplication;
import edu.colorado.phet.common.phetcommon.view.menu.OptionsMenu;
import edu.colorado.phet.faraday.FaradayStrings;
import edu.colorado.phet.faraday.control.dialog.BackgroundColorHandler;
import edu.colorado.phet.faraday.control.dialog.GridControlsDialog;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JDialog;
import javax.swing.JMenuItem;

public class FaradayOptionsMenu
extends OptionsMenu {
    public FaradayOptionsMenu(final PhetApplication phetApplication) {
        final JMenuItem jMenuItem = new JMenuItem(FaradayStrings.MENU_ITEM_BACKGROUND_COLOR);
        jMenuItem.setMnemonic(FaradayStrings.MNEMONIC_BACKGROUND_COLOR);
        jMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                BackgroundColorHandler backgroundColorHandler = new BackgroundColorHandler(phetApplication);
                JDialog jDialog = backgroundColorHandler.getDialog();
                jDialog.addWindowListener(new WindowAdapter(){

                    public void windowClosed(WindowEvent windowEvent) {
                        jMenuItem.setEnabled(true);
                    }

                    public void windowClosing(WindowEvent windowEvent) {
                        jMenuItem.setEnabled(true);
                    }
                });
                jDialog.setVisible(true);
                jMenuItem.setEnabled(false);
            }
        });
        this.add(jMenuItem);
        final JMenuItem jMenuItem2 = new JMenuItem(FaradayStrings.MENU_ITEM_GRID_CONTROLS);
        jMenuItem2.setMnemonic(FaradayStrings.MNEMONIC_GRID_CONTROLS);
        jMenuItem2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                final GridControlsDialog gridControlsDialog = new GridControlsDialog(phetApplication);
                gridControlsDialog.addWindowListener(new WindowAdapter(){

                    public void windowClosed(WindowEvent windowEvent) {
                        jMenuItem2.setEnabled(true);
                    }

                    public void windowClosing(WindowEvent windowEvent) {
                        gridControlsDialog.revert();
                        jMenuItem2.setEnabled(true);
                    }
                });
                gridControlsDialog.setVisible(true);
                jMenuItem2.setEnabled(false);
            }
        });
        this.add(jMenuItem2);
    }
}

