/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.faraday.collision;

import edu.colorado.phet.faraday.collision.ICollidable;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.util.HashSet;

public class CollisionDetector {
    private ICollidable _object;
    private HashSet<ICollidable> _collidables;

    public CollisionDetector(ICollidable iCollidable) {
        this._object = iCollidable;
        this._collidables = new HashSet();
    }

    public void add(ICollidable iCollidable) {
        this._collidables.add(iCollidable);
    }

    public boolean collidesNow() {
        return this.wouldCollide(0, 0);
    }

    public boolean wouldCollide(int n, int n2) {
        boolean bl = false;
        for (ICollidable iCollidable : this._collidables) {
            if (!this.wouldCollide(n, n2, iCollidable)) continue;
            bl = true;
            break;
        }
        return bl;
    }

    private boolean wouldCollide(int n, int n2, ICollidable iCollidable) {
        boolean bl = false;
        AffineTransform affineTransform = new AffineTransform();
        affineTransform.translate(n, n2);
        Shape[] shapeArray = this._object.getCollisionBounds();
        for (int i = 0; i < shapeArray.length && !bl; ++i) {
            Shape shape = affineTransform.createTransformedShape(shapeArray[i]);
            Shape[] shapeArray2 = iCollidable.getCollisionBounds();
            if (shapeArray2 == null) continue;
            for (int j = 0; j < shapeArray2.length && !bl; ++j) {
                Area area = new Area(shape);
                Area area2 = new Area(shapeArray2[j]);
                area.intersect(area2);
                if (area.isEmpty()) continue;
                bl = true;
            }
        }
        return bl;
    }
}

