/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.faraday;

import edu.colorado.phet.common.phetcommon.application.ApplicationConstructor;
import edu.colorado.phet.common.phetcommon.application.PhetApplication;
import edu.colorado.phet.common.phetcommon.application.PhetApplicationConfig;
import edu.colorado.phet.common.phetcommon.application.PhetApplicationLauncher;
import edu.colorado.phet.common.piccolophet.PiccoloPhetApplication;
import edu.colorado.phet.faraday.control.menu.FaradayOptionsMenu;
import edu.colorado.phet.faraday.module.BarMagnetModule;
import edu.colorado.phet.faraday.module.ElectromagnetModule;
import edu.colorado.phet.faraday.module.GeneratorModule;
import edu.colorado.phet.faraday.module.PickupCoilModule;
import edu.colorado.phet.faraday.module.TransformerModule;

public class GeneratorApplication
extends PiccoloPhetApplication {
    public GeneratorApplication(PhetApplicationConfig phetApplicationConfig) {
        super(phetApplicationConfig);
        this.initModules();
        this.initMenubar();
    }

    private void initModules() {
        BarMagnetModule barMagnetModule = new BarMagnetModule(false);
        barMagnetModule.setShowEarthVisible(false);
        this.addModule(barMagnetModule);
        PickupCoilModule pickupCoilModule = new PickupCoilModule();
        this.addModule(pickupCoilModule);
        ElectromagnetModule electromagnetModule = new ElectromagnetModule();
        this.addModule(electromagnetModule);
        TransformerModule transformerModule = new TransformerModule();
        this.addModule(transformerModule);
        GeneratorModule generatorModule = new GeneratorModule();
        this.addModule(generatorModule);
        this.setStartModule(generatorModule);
    }

    private void initMenubar() {
        FaradayOptionsMenu faradayOptionsMenu = new FaradayOptionsMenu(this);
        this.getPhetFrame().addMenu(faradayOptionsMenu);
    }

    public static void main(String[] stringArray) {
        ApplicationConstructor applicationConstructor = new ApplicationConstructor(){

            public PhetApplication getApplication(PhetApplicationConfig phetApplicationConfig) {
                return new GeneratorApplication(phetApplicationConfig);
            }
        };
        PhetApplicationConfig phetApplicationConfig = new PhetApplicationConfig(stringArray, "faraday", "generator");
        new PhetApplicationLauncher().launchSim(phetApplicationConfig, applicationConstructor);
    }
}

