/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.eatingandexercise.view;

import edu.colorado.phet.common.phetcommon.math.Function;
import edu.colorado.phet.eatingandexercise.EatingAndExerciseStrings;
import edu.colorado.phet.eatingandexercise.view.BarChartElement;
import edu.colorado.phet.eatingandexercise.view.BarChartElementNode;
import edu.colorado.phet.eatingandexercise.view.EatingAndExercisePText;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.nodes.PText;
import java.awt.Shape;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.text.DecimalFormat;

public class StackedBarNode
extends PNode {
    private Function function;
    private int barWidth;
    private PNode barChartElementNodeLayer = new PNode();
    private ReadoutNode readoutNode;
    public static final Thumb LEFT = new Thumb("left"){

        public Shape getThumbShape(double d) {
            float f = 10.0f;
            float f2 = 10.0f;
            GeneralPath generalPath = new GeneralPath();
            generalPath.moveTo(0.0f, 0.0f);
            generalPath.lineTo(-f, f2);
            generalPath.lineTo(-f, -f2);
            generalPath.lineTo(0.0f, 0.0f);
            return generalPath;
        }
    };
    public static final Thumb RIGHT = new Thumb("right"){

        public Shape getThumbShape(double d) {
            float f = 10.0f;
            float f2 = 10.0f;
            GeneralPath generalPath = new GeneralPath();
            generalPath.moveTo((float)d, 0.0f);
            generalPath.lineTo((float)((double)f + d), f2);
            generalPath.lineTo((float)((double)f + d), -f2);
            generalPath.lineTo((float)d, 0.0f);
            return generalPath;
        }
    };
    public static final Thumb NONE = new Thumb("none"){

        public Shape getThumbShape(double d) {
            return new Line2D.Double();
        }
    };

    public StackedBarNode(Function function, int n) {
        this.function = function;
        this.barWidth = n;
        this.addChild(this.barChartElementNodeLayer);
        this.readoutNode = new ReadoutNode();
        this.addChild(this.readoutNode);
    }

    public void addElement(BarChartElement barChartElement, Thumb thumb) {
        barChartElement.addListener(new BarChartElement.Listener(){

            public void valueChanged() {
                StackedBarNode.this.relayout();
            }
        });
        BarChartElementNode barChartElementNode = new BarChartElementNode(this, barChartElement, thumb);
        this.barChartElementNodeLayer.addChild(barChartElementNode);
        this.relayout();
    }

    public double getTotal() {
        double d = 0.0;
        for (int i = this.barChartElementNodeLayer.getChildrenCount() - 1; i >= 0; --i) {
            BarChartElementNode barChartElementNode = (BarChartElementNode)this.barChartElementNodeLayer.getChild(i);
            d += barChartElementNode.getBarChartElement().getValue();
        }
        return d;
    }

    private void relayout() {
        DecimalFormat decimalFormat = EatingAndExerciseStrings.KCAL_PER_DAY_FORMAT;
        this.readoutNode.setText(decimalFormat.format(this.getTotal()) + " " + EatingAndExerciseStrings.KCAL_PER_DAY);
        double d = this.modelToView(this.getTotalModelValue());
        double d2 = 0.0;
        for (int i = this.barChartElementNodeLayer.getChildrenCount() - 1; i >= 0; --i) {
            BarChartElementNode barChartElementNode = (BarChartElementNode)this.barChartElementNodeLayer.getChild(i);
            barChartElementNode.setOffset(0.0, d2 - d);
            d2 += this.modelToView(barChartElementNode.getBarChartElement().getValue());
        }
        this.readoutNode.setOffset((double)(this.barWidth / 2) - this.readoutNode.getFullBounds().getWidth() / 2.0, -d2 - this.readoutNode.getFullBounds().getHeight());
    }

    double modelToView(double d) {
        return this.function.evaluate(d);
    }

    private double viewToModel(double d) {
        return this.function.createInverse().evaluate(d);
    }

    double viewToModelDelta(double d) {
        double d2 = this.viewToModel(0.0);
        double d3 = this.viewToModel(d);
        return d3 - d2;
    }

    private double getTotalModelValue() {
        double d = 0.0;
        for (int i = 0; i < this.barChartElementNodeLayer.getChildrenCount(); ++i) {
            d += ((BarChartElementNode)this.barChartElementNodeLayer.getChild(i)).getBarChartElement().getValue();
        }
        return d;
    }

    public double getBarWidth() {
        return this.barWidth;
    }

    public void setFunction(Function function) {
        this.function = function;
        for (int i = 0; i < this.barChartElementNodeLayer.getChildrenCount(); ++i) {
            ((BarChartElementNode)this.barChartElementNodeLayer.getChild(i)).updateShape();
        }
        this.relayout();
    }

    private class ReadoutNode
    extends PNode {
        private PText child = new EatingAndExercisePText("Text");

        private ReadoutNode() {
            this.addChild(this.child);
        }

        public void setText(String string) {
            this.child.setText(string);
        }
    }

    public static abstract class Thumb {
        private String name;

        public Thumb(String string) {
            this.name = string;
        }

        public abstract Shape getThumbShape(double var1);
    }
}

