/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.eatingandexercise.view;

import edu.colorado.phet.common.phetcommon.math.Function;
import edu.colorado.phet.common.phetcommon.view.util.PhetFont;
import edu.colorado.phet.common.piccolophet.nodes.PhetPPath;
import edu.colorado.phet.eatingandexercise.view.EatingAndExercisePText;
import edu.umd.cs.piccolo.PNode;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Paint;
import java.awt.Stroke;
import java.awt.geom.Line2D;
import java.text.DecimalFormat;

public class SparseStackedBarChartAxisNode
extends PNode {
    private Function function;
    private double majorTickSpacing;
    private double max;

    public SparseStackedBarChartAxisNode(String string, Function function, double d, double d2, double d3) {
        PNode pNode;
        double d4;
        this.function = function;
        this.majorTickSpacing = d2;
        this.max = d3;
        for (d4 = 0.0; d4 <= d3; d4 += d) {
            if (this.isMajorTick(d4)) continue;
            pNode = new MinorTick(8.0, d4);
            this.addChild(pNode);
        }
        for (d4 = 0.0; d4 <= d3; d4 += d2) {
            pNode = new MajorTick(10.0, d4);
            this.addChild(pNode);
        }
    }

    private boolean isMajorTick(double d) {
        for (double d2 = 0.0; d2 <= this.max; d2 += this.majorTickSpacing) {
            if (!(Math.abs(d - d2) < 1.0E-6)) continue;
            return true;
        }
        return false;
    }

    private double modelToView(double d) {
        return this.function.evaluate(d);
    }

    public class MajorTick
    extends PNode {
        public MajorTick(double d, double d2) {
            PhetPPath phetPPath = new PhetPPath(new Line2D.Double(-d / 2.0, -SparseStackedBarChartAxisNode.this.modelToView(d2), d / 2.0, -SparseStackedBarChartAxisNode.this.modelToView(d2)), (Stroke)new BasicStroke(2.0f), (Paint)Color.black);
            this.addChild(phetPPath);
            EatingAndExercisePText eatingAndExercisePText = new EatingAndExercisePText(new DecimalFormat("0").format(d2));
            eatingAndExercisePText.setFont(new PhetFont(12, true));
            this.addChild(eatingAndExercisePText);
            eatingAndExercisePText.setOffset(phetPPath.getFullBounds().getCenterX() - eatingAndExercisePText.getFullBounds().getWidth() / 2.0, phetPPath.getFullBounds().getCenterY() - eatingAndExercisePText.getFullBounds().getHeight() / 2.0);
            phetPPath.setVisible(false);
        }
    }

    public class MinorTick
    extends PNode {
        public MinorTick(double d, double d2) {
            PhetPPath phetPPath = new PhetPPath(new Line2D.Double(-d / 2.0, -SparseStackedBarChartAxisNode.this.modelToView(d2), d / 2.0, -SparseStackedBarChartAxisNode.this.modelToView(d2)), (Stroke)new BasicStroke(1.0f), (Paint)Color.black);
            this.addChild(phetPPath);
        }
    }
}

