/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.eatingandexercise.view;

import edu.colorado.phet.common.phetcommon.view.VerticalLayoutPanel;
import edu.colorado.phet.common.phetcommon.view.util.DoubleGeneralPath;
import edu.colorado.phet.common.piccolophet.nodes.PhetPPath;
import edu.colorado.phet.eatingandexercise.EatingAndExerciseResources;
import edu.colorado.phet.eatingandexercise.EatingAndExerciseStrings;
import edu.colorado.phet.eatingandexercise.model.Human;
import edu.colorado.phet.eatingandexercise.module.eatingandexercise.EatingAndExerciseModel;
import edu.colorado.phet.eatingandexercise.view.EatingAndExercisePText;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.nodes.PText;
import edu.umd.cs.piccolox.pswing.PSwing;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JRadioButton;

public class ScaleNode
extends PNode {
    private static final Color SCALE_COLOR = Color.LIGHT_GRAY;
    private static final String BMI_LABEL = EatingAndExerciseResources.getString("bmi");
    private static final String BMI_UNITS = EatingAndExerciseResources.getString("units.bmi");
    private final EatingAndExerciseModel model;
    private final Human human;
    private final PText weightBMIReadout;

    public ScaleNode(final EatingAndExerciseModel eatingAndExerciseModel, Human human) {
        this.model = eatingAndExerciseModel;
        this.human = human;
        DoubleGeneralPath doubleGeneralPath = new DoubleGeneralPath();
        doubleGeneralPath.moveTo(-0.45, 0.05);
        doubleGeneralPath.lineTo(-0.39, -0.05);
        doubleGeneralPath.lineTo(0.39, -0.05);
        doubleGeneralPath.lineTo(0.45, 0.05);
        doubleGeneralPath.lineTo(-0.45, 0.05);
        this.addChild(new PhetPPath(doubleGeneralPath.getGeneralPath(), SCALE_COLOR, new BasicStroke(0.02f), Color.black));
        DoubleGeneralPath doubleGeneralPath2 = new DoubleGeneralPath();
        doubleGeneralPath2.moveTo(-0.45, 0.05);
        doubleGeneralPath2.lineTo(-0.45, 0.18);
        doubleGeneralPath2.lineTo(0.45, 0.18);
        doubleGeneralPath2.lineTo(0.45, 0.05);
        doubleGeneralPath2.lineTo(-0.45, 0.05);
        PhetPPath phetPPath = new PhetPPath(doubleGeneralPath2.getGeneralPath(), SCALE_COLOR, new BasicStroke(0.02f), Color.black);
        this.addChild(phetPPath);
        human.addListener(new Human.Adapter(){

            public void weightChanged() {
                ScaleNode.this.updateReadout();
            }

            public void bmiChanged() {
                ScaleNode.this.updateReadout();
            }
        });
        this.weightBMIReadout = new EatingAndExercisePText("??");
        this.weightBMIReadout.scale(0.005714285714285714);
        this.addChild(this.weightBMIReadout);
        this.updateReadout();
        VerticalLayoutPanel verticalLayoutPanel = new VerticalLayoutPanel();
        verticalLayoutPanel.setBorder(BorderFactory.createBevelBorder(1));
        ButtonGroup buttonGroup = new ButtonGroup();
        for (int i = 0; i < EatingAndExerciseModel.availableUnits.length; ++i) {
            final JRadioButton jRadioButton = new JRadioButton(EatingAndExerciseModel.availableUnits[i].getShortName(), EatingAndExerciseModel.availableUnits[i] == eatingAndExerciseModel.getUnits());
            buttonGroup.add(jRadioButton);
            ((Container)verticalLayoutPanel).add(jRadioButton);
            final EatingAndExerciseModel.Units units = EatingAndExerciseModel.availableUnits[i];
            jRadioButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    eatingAndExerciseModel.setUnits(units);
                }
            });
            eatingAndExerciseModel.addListener(new EatingAndExerciseModel.Adapter(){

                public void unitsChanged() {
                    jRadioButton.setSelected(eatingAndExerciseModel.getUnits() == units);
                }
            });
        }
        PSwing pSwing = new PSwing(verticalLayoutPanel);
        pSwing.setOffset(0.4599999997764826, 0.0);
        pSwing.scale(0.004285714285714286);
        this.addChild(pSwing);
        eatingAndExerciseModel.addListener(new EatingAndExerciseModel.Adapter(){

            public void unitsChanged() {
                ScaleNode.this.updateReadout();
            }
        });
    }

    private void updateReadout() {
        this.weightBMIReadout.setText("" + EatingAndExerciseStrings.WEIGHT_FORMAT.format(this.model.getUnits().modelToViewMass(this.human.getMass())) + " " + this.model.getUnits().getMassUnit() + ", " + BMI_LABEL + ": " + EatingAndExerciseStrings.BMI_FORMAT.format(this.human.getBMI()) + " " + BMI_UNITS);
        this.updateTextLayout();
    }

    private void updateTextLayout() {
        this.weightBMIReadout.setOffset(0.0 - this.weightBMIReadout.getFullBounds().getWidth() / 2.0, 0.18 - this.weightBMIReadout.getFullBounds().getHeight() - 0.01);
    }
}

