/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.eatingandexercise.control;

import edu.colorado.phet.common.phetcommon.view.util.BufferedImageUtils;
import edu.colorado.phet.eatingandexercise.EatingAndExerciseResources;
import edu.colorado.phet.eatingandexercise.EatingAndExerciseStrings;
import edu.colorado.phet.eatingandexercise.control.CaloricItem;
import edu.colorado.phet.eatingandexercise.view.EatingAndExercisePText;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.nodes.PImage;

public class SummaryItemNode
extends PNode {
    private CaloricItem item;

    public SummaryItemNode(CaloricItem caloricItem, int n) {
        this.item = caloricItem;
        PNode pNode = caloricItem.getImage() != null && caloricItem.getImage().trim().length() > 0 ? new PImage(BufferedImageUtils.multiScaleToHeight(EatingAndExerciseResources.getImage(caloricItem.getImage()), 30)) : new EatingAndExercisePText(caloricItem.getName());
        this.addChild(pNode);
        EatingAndExercisePText eatingAndExercisePText = new EatingAndExercisePText("=" + EatingAndExerciseStrings.KCAL_PER_DAY_FORMAT.format(caloricItem.getCalories()) + " " + EatingAndExerciseStrings.KCAL_PER_DAY);
        this.addChild(eatingAndExercisePText);
        eatingAndExercisePText.setOffset(pNode.getFullBounds().getWidth(), pNode.getFullBounds().getCenterY() - eatingAndExercisePText.getFullBounds().getHeight() / 2.0);
        if (n != 1) {
            EatingAndExercisePText eatingAndExercisePText2 = new EatingAndExercisePText("" + n + " x");
            eatingAndExercisePText2.setOffset(pNode.getFullBounds().getX() - eatingAndExercisePText2.getFullBounds().getWidth(), pNode.getFullBounds().getCenterY() - eatingAndExercisePText2.getFullBounds().getHeight() / 2.0);
            this.addChild(eatingAndExercisePText2);
        }
    }

    public CaloricItem getItem() {
        return this.item;
    }
}

