/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.common.piccolophet.nodes;

import edu.colorado.phet.common.phetcommon.math.Function;
import edu.colorado.phet.common.phetcommon.math.MathUtil;
import edu.colorado.phet.common.phetcommon.view.util.DoubleGeneralPath;
import edu.colorado.phet.common.piccolophet.event.CursorHandler;
import edu.colorado.phet.common.piccolophet.nodes.PhetPPath;
import edu.umd.cs.piccolo.PComponent;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.event.PBasicInputEventHandler;
import edu.umd.cs.piccolo.event.PInputEvent;
import edu.umd.cs.piccolo.nodes.PPath;
import edu.umd.cs.piccolo.util.PDimension;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.Window;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.RoundRectangle2D;
import java.util.ArrayList;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class SliderNode
extends PNode {
    private int width = 160;
    private int height = 30;
    private double min;
    private double max;
    private double value;
    private KnobNode knobNode;
    private ArrayList<ChangeListener> listeners = new ArrayList();

    public SliderNode(double d, double d2, double d3) {
        this.min = d;
        this.max = d2;
        this.value = d3;
        TrackNode trackNode = new TrackNode();
        this.knobNode = new KnobNode();
        PhetPPath phetPPath = new PhetPPath(new Color(0, 0, 0, 0));
        phetPPath.addInputEventListener(new PBasicInputEventHandler(){

            public void mousePressed(PInputEvent pInputEvent) {
                double d = pInputEvent.getPositionRelativeTo(SliderNode.this).getX();
                double d2 = SliderNode.this.viewToModel(d);
                double d3 = SliderNode.this.max - SliderNode.this.min;
                double d4 = d3 / 20.0;
                double d5 = d2 > SliderNode.this.getValue() ? 1.0 : -1.0;
                SliderNode.this.setValue(SliderNode.this.getValue() + d5 * d4);
            }
        });
        this.addInputEventListener(new CursorHandler());
        this.addChild(trackNode);
        this.addChild(phetPPath);
        this.addChild(this.knobNode);
        this.updateKnob();
        phetPPath.setPathTo(trackNode.getFullBounds().createUnion(this.knobNode.getFullBounds()));
    }

    public double getValue() {
        return this.value;
    }

    public void addChangeListener(ChangeListener changeListener) {
        this.listeners.add(changeListener);
    }

    public void setRange(double d, double d2) {
        this.min = d;
        this.max = d2;
        this.updateKnob();
    }

    protected Shape createTrackShape(double d, double d2) {
        return new BasicStroke(2.0f).createStrokedShape(new Line2D.Double(this.modelToView(d), this.height / 2, this.modelToView(d2), this.height / 2));
    }

    protected void updateKnob() {
        this.updateKnobLocation();
        Shape shape = new RoundRectangle2D.Double(0.0, 0.0, this.knobNode.getKnobWidth(), this.knobNode.getKnobHeight(), 6.0, 6.0);
        if (this.value < this.min) {
            DoubleGeneralPath doubleGeneralPath = new DoubleGeneralPath();
            doubleGeneralPath.moveTo(this.knobNode.getKnobWidth(), 0.0);
            doubleGeneralPath.lineTo(0.0, this.knobNode.getKnobHeight() / 2.0);
            doubleGeneralPath.lineTo(this.knobNode.getKnobWidth(), this.knobNode.getKnobHeight());
            doubleGeneralPath.lineTo(this.knobNode.getKnobWidth(), 0.0);
            shape = doubleGeneralPath.getGeneralPath();
        } else if (this.value > this.max) {
            DoubleGeneralPath doubleGeneralPath = new DoubleGeneralPath();
            doubleGeneralPath.moveTo(0.0, 0.0);
            doubleGeneralPath.lineTo(this.knobNode.getKnobWidth(), this.knobNode.getKnobHeight() / 2.0);
            doubleGeneralPath.lineTo(0.0, this.knobNode.getKnobHeight());
            doubleGeneralPath.lineTo(0.0, 0.0);
            shape = doubleGeneralPath.getGeneralPath();
        }
        this.knobNode.setKnobState(new KnobState(this.value < this.min || this.value > this.max ? Color.red : new Color(237, 200, 120), shape));
    }

    private void updateKnobLocation() {
        this.knobNode.setOffset(this.modelToView(this.getClampedValue()), 0.0);
        this.repaint();
    }

    private double getClampedValue() {
        return this.clamp(this.value);
    }

    protected double clamp(double d) {
        return MathUtil.clamp(this.min, d, this.max);
    }

    private double modelToView(double d) {
        return new Function.LinearFunction(this.min, this.max, 0.0, this.width).evaluate(d);
    }

    private double viewToModel(double d) {
        return new Function.LinearFunction(0.0, this.width, this.min, this.max).evaluate(d);
    }

    private double viewToModelRelative(double d) {
        return d * (this.max - this.min) / (double)(this.width - 0);
    }

    private void setCursorHand(Container container, Cursor cursor) {
        container.setCursor(cursor);
        for (int i = 0; i < container.getComponentCount(); ++i) {
            Component component = container.getComponent(i);
            component.setCursor(cursor);
            if (!(component instanceof Container)) continue;
            this.setCursorHand((Container)component, cursor);
        }
    }

    public void setValue(double d) {
        if (this.value != d) {
            this.value = d;
            this.notifyValueChanged();
            this.updateKnob();
        }
    }

    private void notifyValueChanged() {
        for (int i = 0; i < this.listeners.size(); ++i) {
            this.listeners.get(i).stateChanged(new ChangeEvent(this));
        }
    }

    protected class KnobNode
    extends PNode {
        private int knobWidth = 10;
        private int knobHeight = 30;
        private Point2D dragStartPT;
        private PPath knob = new PhetPPath(new RoundRectangle2D.Double(0.0, 0.0, this.knobWidth, this.knobHeight, 6.0, 6.0), new Color(237, 200, 120), new BasicStroke(), Color.black);

        private KnobNode() {
            this.knob.setOffset(-this.knob.getFullBounds().getWidth() / 2.0, (double)(SliderNode.this.height / 2) - this.knob.getFullBounds().getHeight() / 2.0);
            this.addInputEventListener(new CursorHandler());
            this.addInputEventListener(new PBasicInputEventHandler(){

                public void mouseEntered(PInputEvent pInputEvent) {
                    KnobNode.this.handleMouse(pInputEvent, Cursor.getPredefinedCursor(12));
                }

                public void mouseExited(PInputEvent pInputEvent) {
                    KnobNode.this.handleMouse(pInputEvent, Cursor.getPredefinedCursor(0));
                }
            });
            this.addInputEventListener(new PBasicInputEventHandler(){

                public void mousePressed(PInputEvent pInputEvent) {
                    KnobNode.this.dragStartPT = pInputEvent.getPositionRelativeTo(KnobNode.this);
                }

                public void mouseDragged(PInputEvent pInputEvent) {
                    Point2D point2D = pInputEvent.getPositionRelativeTo(KnobNode.this);
                    PDimension pDimension = new PDimension(point2D.getX() - KnobNode.this.dragStartPT.getX(), point2D.getY() - point2D.getY());
                    KnobNode.this.localToGlobal(pDimension);
                    double d = SliderNode.this.value + SliderNode.this.viewToModelRelative(pDimension.getWidth());
                    SliderNode.this.setValue(SliderNode.this.clamp(d));
                }
            });
            this.addChild(this.knob);
        }

        private void handleMouse(PInputEvent pInputEvent, Cursor cursor) {
            JComponent jComponent;
            Window window;
            PComponent pComponent = pInputEvent.getComponent();
            if (pComponent instanceof JComponent && (window = SwingUtilities.getWindowAncestor(jComponent = (JComponent)((Object)pComponent))) instanceof JFrame) {
                JFrame jFrame = (JFrame)window;
                Container container = jFrame.getContentPane();
                SliderNode.this.setCursorHand(container, cursor);
            }
        }

        public void setKnobState(KnobState knobState) {
            this.setKnobPaint(knobState.paint);
            this.knob.setPathTo(knobState.shape);
        }

        public void setKnobPaint(Paint paint) {
            this.knob.setPaint(paint);
        }

        public double getKnobWidth() {
            return this.knobWidth;
        }

        public double getKnobHeight() {
            return this.knobHeight;
        }
    }

    public static class KnobState {
        public final Paint paint;
        public final Shape shape;

        public KnobState(Paint paint, Shape shape) {
            this.paint = paint;
            this.shape = shape;
        }
    }

    protected class TrackNode
    extends PNode {
        protected TrackNode() {
            PhetPPath phetPPath = new PhetPPath(SliderNode.this.createTrackShape(SliderNode.this.min, SliderNode.this.max), Color.lightGray, new BasicStroke(1.0f), Color.black);
            this.addChild(phetPPath);
        }
    }
}

