/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.common.piccolophet.nodes;

import edu.umd.cs.piccolo.PCanvas;
import edu.umd.cs.piccolo.nodes.PPath;
import edu.umd.cs.piccolo.util.PBounds;
import edu.umd.cs.piccolo.util.PPaintContext;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;

public class IncrementalPPath
extends PPath {
    private PCanvas pCanvas;
    private boolean doingLineTo = false;
    ArrayList pts = new ArrayList();
    private static boolean updatingAndPainting = false;
    private boolean updatingBoundsFromPath = false;

    public IncrementalPPath(PCanvas pCanvas) {
        this.pCanvas = pCanvas;
        PropertyChangeListener propertyChangeListener = new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                IncrementalPPath.this.pts.clear();
                IncrementalPPath.this.repaint();
            }
        };
        this.addPropertyChangeListener("transform", propertyChangeListener);
        this.addPropertyChangeListener("stroke", propertyChangeListener);
    }

    public void lineTo(float f, float f2) {
        this.pts.add(new Point2D.Double(f, f2));
        Point2D point2D = this.getPathReference().getCurrentPoint();
        this.doingLineTo = true;
        this.localLineTo(f, f2, point2D);
        this.doingLineTo = false;
        Point2D point2D2 = this.getPathReference().getCurrentPoint();
        Line2D.Double double_ = new Line2D.Double(point2D, point2D2);
        Rectangle2D rectangle2D = this.getStroke().createStrokedShape(double_).getBounds2D();
        this.localToGlobal(rectangle2D);
        updatingAndPainting = true;
        this.globalBoundsChanged(rectangle2D);
        updatingAndPainting = false;
    }

    private void localLineTo(float f, float f2, Point2D point2D) {
        this.getPathReference().lineTo(f, f2);
        this.firePropertyChange(262144, "path", null, this.getPathReference());
        this.localUpdateBoundsFromPath(point2D);
        this.invalidatePaint();
    }

    protected void paint(PPaintContext pPaintContext) {
        Paint paint = this.getPaint();
        Graphics2D graphics2D = pPaintContext.getGraphics();
        if (paint != null) {
            graphics2D.setPaint(paint);
            graphics2D.fill(this.getPathReference());
        }
        if (this.getStroke() != null && this.getStrokePaint() != null) {
            graphics2D.setPaint(this.getStrokePaint());
            graphics2D.setStroke(this.getStroke());
            int n = 30;
            if (this.pts.size() < n || !updatingAndPainting) {
                System.out.println("rendering full path: updating&P=" + updatingAndPainting);
                graphics2D.draw(this.getPathReference());
            } else {
                GeneralPath generalPath = new GeneralPath();
                generalPath.moveTo((float)this.getPreviousPoint(0).getX(), (float)this.getPreviousPoint(0).getY());
                for (int i = 1; i < n; ++i) {
                    generalPath.lineTo((float)this.getPreviousPoint(i).getX(), (float)this.getPreviousPoint(i).getY());
                }
                graphics2D.draw(generalPath);
            }
        }
    }

    private Point2D getPreviousPoint(int n) {
        return (Point2D)this.pts.get(this.pts.size() - 1 - n);
    }

    protected void internalUpdateBounds(double d, double d2, double d3, double d4) {
        if (this.updatingBoundsFromPath) {
            return;
        }
        super.internalUpdateBounds(d, d2, d3, d4);
    }

    private void localUpdateBoundsFromPath(Point2D point2D) {
        this.updatingBoundsFromPath = true;
        if (this.getPathReference() == null) {
            this.resetBounds();
        } else {
            Rectangle2D rectangle2D = this.getBounds().createUnion(this.getLastSegmentBoundsWithStroke(point2D));
            this.setBounds(rectangle2D.getX(), rectangle2D.getY(), rectangle2D.getWidth(), rectangle2D.getHeight());
        }
        this.updatingBoundsFromPath = false;
    }

    private Rectangle2D getLastSegmentBoundsWithStroke(Point2D point2D) {
        if (this.getStroke() != null && point2D != null) {
            Line2D.Double double_ = new Line2D.Double(this.getPathReference().getCurrentPoint(), point2D);
            return this.getStroke().createStrokedShape(double_).getBounds2D();
        }
        return this.getPathReference().getBounds2D();
    }

    protected void globalBoundsChanged(Rectangle2D rectangle2D) {
        this.repaintGlobalBounds(rectangle2D);
    }

    protected void repaintGlobalBounds(Rectangle2D rectangle2D) {
        this.pCanvas.repaint(new PBounds(rectangle2D));
    }

    protected void repaintGlobalBoundsImmediately(Rectangle2D rectangle2D) {
        this.pCanvas.paintImmediately(rectangle2D.getBounds());
    }

    public void invalidatePaint() {
        if (!this.doingLineTo) {
            super.invalidatePaint();
        }
    }
}

