/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.idealgas.collision;

import edu.colorado.phet.idealgas.collision.CollidableBody;
import edu.colorado.phet.idealgas.collision.CollisionExpert;
import edu.colorado.phet.idealgas.collision.SphereSphereCollision;
import edu.colorado.phet.idealgas.collision.SphereSphereContactDetector;
import edu.colorado.phet.idealgas.collision.SphericalBody;
import edu.colorado.phet.idealgas.model.GasMolecule;
import edu.colorado.phet.idealgas.model.IdealGasModel;

public class SphereSphereExpert
implements CollisionExpert {
    private static boolean ignoreGasMoleculeInteractions = false;
    private SphereSphereContactDetector detector = new SphereSphereContactDetector();
    private IdealGasModel model;
    private double dt;

    public static void setIgnoreGasMoleculeInteractions(boolean bl) {
        ignoreGasMoleculeInteractions = bl;
    }

    public SphereSphereExpert(IdealGasModel idealGasModel, double d) {
        this.model = idealGasModel;
        this.dt = d;
    }

    public boolean detectAndDoCollision(CollidableBody collidableBody, CollidableBody collidableBody2) {
        boolean bl = false;
        if (collidableBody instanceof GasMolecule && collidableBody2 instanceof GasMolecule && ignoreGasMoleculeInteractions) {
            return false;
        }
        if (this.detector.applies(collidableBody, collidableBody2) && this.detector.areInContact(collidableBody, collidableBody2) && this.tweakCheck(collidableBody, collidableBody2)) {
            SphereSphereCollision sphereSphereCollision = new SphereSphereCollision((SphericalBody)collidableBody, (SphericalBody)collidableBody2);
            sphereSphereCollision.collide();
            bl = true;
        }
        return bl;
    }

    private boolean tweakCheck(CollidableBody collidableBody, CollidableBody collidableBody2) {
        SphericalBody sphericalBody = (SphericalBody)collidableBody;
        SphericalBody sphericalBody2 = (SphericalBody)collidableBody2;
        double d = sphericalBody.getPositionPrev().distance(sphericalBody2.getPositionPrev());
        return d > sphericalBody.getRadius() + sphericalBody2.getRadius();
    }
}

